 function [L,flag] = MChol(A)
 %  Eingabe: A  eine symmetrische positiv definite n x n Matrix.
 %       
 %  Ausgabe: L  eine untere Dreiecksmatrix, so, dass A = L*L' 
 %           flag Statusmeldung  flag = k > 0 Fehler im k-ten Schritt 
 %                                    = 0   erfolgreiche Zerlegung

[m,n] = size(A);

% 1. % -> not
if not(m == n)
   error('Die Matrix muss quadratisch sein')
end

% 2. 1 -> 0
flag = 0;

for j = 1:n, 
  %    Abbruch falls A nicht positiv definit ist
  % 3. <= -1 -> < 0
  if A(j,j) < 0
      flag = j; 
      % 4. define L
      L = A;
      return ; 
  end

  % Berechnung der Diagonale und der darunterliegenden Spalte
  A(j,j) = sqrt(A(j,j));
  % 5. + -> :
  A(j+1:n,j) = A(j+1:n,j)/A(j,j);
  
  % Aktualisiere den restlichen linken unteren Block 
  for k = j+1:n,
    A(j:n,k) = A(j:n,k) - A(j:n,j)*A(k,j);
  end
end
% 6. trill -> tril
L = tril(A);
