function [x] = myfft(x)

N = numel(x);

if N>=2		
	uh = myfft(x(1:2:N-1));
	vh = myfft(x(2:2:N));
	Nh = N/2;
	omega = exp((-2*pi*1i/N)*(0:Nh-1));
	x(1:Nh)   = uh+omega.*vh;
	x(Nh+1:N) = uh-omega.*vh;
end